import numpy as np
import matplotlib.pyplot as plt

from utils import get_individual_regret, merge_comm

feducb_regrets = np.load('~/plt/feducb/ind_reg_list_10.npy')
feducb_individual_regret_mean, feducb_individual_regret_std = get_individual_regret(feducb_regrets)
# feducb_individual_regret_mean = np.load('~/plt/feducb/avg_regret_mean.npy')
# feducb_individual_regret_std = np.load('~/plt/feducb/avg_regret_std.npy')

# des_regrets_10 = np.load('~/plt/des/regret_lists_new_1e6_10.npy')
# des_regrets_40 = np.load('~/plt/des/regret_lists_new_1e6_40.npy')
# des_regrets = merge_comm([des_regrets_10, des_regrets_40])
des_regrets = np.load('~/plt/des/regret_lists_new_1e6_50_1.npy')
# print(f'des_regrets :{des_regrets.shape}')
des_individual_regret_mean, des_individual_regret_std = get_individual_regret(des_regrets)


tomf_regrets = [np.load('~/plt/tomf/regret_list_hetero_1e6_50.npy'),
                np.load('~/plt/tomf/regret_list_hetero_1e6_50.npy')]
tomf_regrets = merge_comm(tomf_regrets)
tomf_individual_regret_mean, tomf_individual_regret_std = get_individual_regret(tomf_regrets)

gossip_regret = np.load('~/plt/gossip/regret_lists.npy')
gossip_individual_regret_mean, gossip_individual_regret_std = get_individual_regret(gossip_regret)


ducb_regrets = [np.load('~/plt/ducb/regret_lists_10.npy'),
               np.load('~/plt/ducb/regret_lists_20.npy'),
               np.load('~/plt/ducb/regret_lists_30.npy'),
               np.load('~/plt/ducb/regret_lists_40.npy'),
               np.load('~/plt/ducb/regret_lists_50.npy')]
ducb_regrets = merge_comm(ducb_regrets)
ducb_individual_regret_mean, ducb_individual_regret_std = get_individual_regret(ducb_regrets)


plt.rcParams['font.family'] = 'serif'
plt.rcParams['font.size'] = 20
plt.rcParams['axes.labelweight'] = 'bold'

markevery=100000

plt.figure(figsize=(10, 7))


plt.plot(feducb_individual_regret_mean, linestyle='--', marker='^', color='blue', label='Fed2-UCB',
         markersize=8, markerfacecolor='white', markeredgewidth=2, markevery=markevery)
plt.fill_between(range(len(feducb_individual_regret_mean)),
                 feducb_individual_regret_mean - feducb_individual_regret_std,
                 feducb_individual_regret_mean + feducb_individual_regret_std,
                 color='blue', alpha=0.08)

plt.plot(tomf_individual_regret_mean, linestyle=':', marker='*', color='red', label='UCB-TCOM',
         markersize=12, markerfacecolor='white', markeredgewidth=2, markevery=markevery)
plt.fill_between(range(len(tomf_individual_regret_mean)),
                 tomf_individual_regret_mean - tomf_individual_regret_std,
                 tomf_individual_regret_mean + tomf_individual_regret_std,
                 color='red', alpha=0.08)

plt.plot(gossip_individual_regret_mean, linestyle='-', marker='o', color='green', label='Gossip_UCB',
         markersize=8, markerfacecolor='white', markeredgewidth=2, markevery=markevery)
plt.fill_between(range(len(gossip_individual_regret_mean)),
                 gossip_individual_regret_mean - gossip_individual_regret_std,
                 gossip_individual_regret_mean + gossip_individual_regret_std,
                 color='green', alpha=0.08)

plt.plot(des_individual_regret_mean, linestyle='-.', marker='D', color='purple', label='EpoInc-SE',
         markersize=8, markerfacecolor='white', markeredgewidth=2, markevery=markevery)
plt.fill_between(range(len(des_individual_regret_mean)), 
                 des_individual_regret_mean - des_individual_regret_std, 
                 des_individual_regret_mean + des_individual_regret_std, 
                 color='purple', alpha=0.08)


plt.plot(ducb_individual_regret_mean, linestyle='--', marker='x', color='brown', label='Dis-UCB', 
         markersize=10, markerfacecolor='white',  markeredgewidth=2, markevery=markevery)
plt.fill_between(range(len(ducb_individual_regret_mean)), 
                 ducb_individual_regret_mean - ducb_individual_regret_std, 
                 ducb_individual_regret_mean + ducb_individual_regret_std, 
                 color='c', alpha=0.08)

# print(des_group_regret_mean)
plt.xlabel('Time Slots')
plt.ylabel('Individual Regret')
plt.yscale('log')
plt.grid(False)            # 去掉网格
plt.tight_layout()
plt.ylim(10, int(1e5))
plt.legend()
plt.tight_layout()
plt.savefig('~/plt/Individual_Regret.png', dpi=300)
# plt.show()
